package com.hero.ui.dialog;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JLabel;
import javax.swing.JPanel;

import com.hero.objects.GenericObject;
import com.hero.objects.perks.ResourcePool;
import com.hero.ui.widgets.LevelTF;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class ResourcePoolDialog extends PerkDialog {

	private static final long serialVersionUID = -6126546559060075704L;

	private JLabel freePointsLbl;

	private LevelTF freePointsTF;

	public ResourcePoolDialog(ResourcePool pk, boolean isNew, boolean isPower) {
		super(pk, isNew, isPower);
	}

	@Override
	protected JPanel getTopPanel() {
		JPanel panel = super.getTopPanel();
		GridBagConstraints gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 68;
		gbc.weightx = 0;
		gbc.weighty = 0;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.fill = GridBagConstraints.NONE;
		gbc.anchor = GridBagConstraints.EAST;
		gbc.insets = new Insets(2, 5, 5, 2);
		panel.add(freePointsLbl, gbc);
		gbc.gridx = 1;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.gridwidth = 2;
		panel.add(freePointsTF, gbc);

		return panel;
	}

	@Override
	protected void initListeners() {
		super.initListeners();
		freePointsTF.addPropertyChangeListener("Level",
				new PropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent e) {
						ResourcePool rp = (ResourcePool) perk;
						int fp = rp.getFreePoints();
						if (fp == freePointsTF.getCurrent()) {
							return;
						}
						rp.setFreePoints(freePointsTF.getCurrent());
						GenericObject.lastEdit = System.currentTimeMillis();
						updateValues();
					}
				});
	}

	@Override
	protected void initWidgets() {
		super.initWidgets();
		freePointsLbl = new JLabel("Starting Points:");
		freePointsTF = new LevelTF(((ResourcePool) perk).getFreePoints(), 9999,
				0);
	}

	@Override
	public void updateValues() {
		super.updateValues();
		ResourcePool rp = (ResourcePool) perk;
		freePointsTF.setCurrent(rp.getFreePoints());
		if ((rp.getLevelCost() < 1) || (rp.getLevelValue() < 1)) {
			levelsLbl.setVisible(false);
			levelTF.setVisible(false);
			rp.setLevels(0);
		} else {
			levelsLbl.setVisible(true);
			levelTF.setVisible(true);
		}
	}
}